#pragma once 

#include <GL/glew.h>
#include <GL/gl.h>
#include <string>

namespace graphics
{
	/*!
		OpenGL shader
	*/
class Shader
{
public:
    Shader();
	/*!
		Compile shader from the given \a file. The shader is of type \a target.
	*/
    Shader(const std::string & file, GLenum target);
	Shader(const Shader & shader) = delete;
	Shader & operator = (const Shader & shader) = delete;
	~Shader();
	/*!
		compiles the shader
	*/
	void build();
	/*!
		binds the compiled shader to the given program
	*/
    void bindToProgram(GLuint program) const;
private:
    std::string m_file;
    GLenum m_target;
    GLuint m_shaderObject;
};

};
